VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "DBaskets"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = True
Attribute VB_Ext_KEY = "RVB_UniqueId" ,"33FA08CE02E0"
'
'
Option Base 0
Option Explicit

Implements ObjectControl

Private oDb As ADODB.Connection
Private oRs As ADODB.Recordset

Private oObjectContext As ObjectContext

Private Function ObjectControl_CanBePooled() As Boolean
    ObjectControl_CanBePooled = True
End Function

Private Sub ObjectControl_Deactivate()
    Set oObjectContext = Nothing
    Set oDb = Nothing
    Set oRs = Nothing
    
End Sub


Private Sub ObjectControl_Activate()
    On Error GoTo OCActivateErr
   
    Set oObjectContext = GetObjectContext()
    
    Exit Sub

OCActivateErr:
    Call RaiseError("OCActivate")

End Sub
Public Function GetBasketItems(ByVal vOrderID As Variant) As Variant
    On Error GoTo GetBasketItemsErr

    Dim vResponse As New Collection
    Dim vItems As New Collection
    Dim vSql As Variant
    Dim vCode As Variant
    Dim vName As Variant
    Dim vBasketId As Variant
    Dim vPrice As Variant
    Dim vPromotionCode As Variant
    Dim vPromotionEndDate As Variant
    Dim vNumItems As Variant
    
    Let vSql = "SELECT BasketContents.*, Catalog.*, Promotion.PromotionCode, Promotion.PromotionEndDate" & _
        " FROM (BasketContents INNER JOIN Catalog ON BasketContents.CatalogId = Catalog.CatalogId) LEFT JOIN Promotion ON Catalog.CatalogId = Promotion.CatalogID" & _
        " WHERE BasketContents.OrderID = " & vOrderID & ";"
    Trace vSql
          
    Set oDb = oObjectContext.CreateInstance("ADODB.Connection")
    oDb.Open vDbConn
    Set oRs = oDb.Execute(vSql)
    
    While Not oRs.EOF
        Dim BasketItem As New Collection
    
        vBasketId = oRs.Fields("basketid")
        vCode = oRs.Fields("code")
        vName = oRs.Fields("name")
        vPrice = oRs.Fields("price")
        vNumItems = oRs.Fields("numitems")
        vPromotionCode = oRs.Fields("promotioncode")
        vPromotionEndDate = oRs.Fields("promotionenddate")
        
        BasketItem.Add vBasketId, Key:="basketid"
        BasketItem.Add vCode, Key:="code"
        BasketItem.Add vName, Key:="name"
        BasketItem.Add vPrice, Key:="price"
        BasketItem.Add vNumItems, Key:="numitems"
        BasketItem.Add vPromotionCode, Key:="promotioncode"
        BasketItem.Add vPromotionEndDate, Key:="promotionenddate"

        vItems.Add BasketItem
    
        Set BasketItem = Nothing
        oRs.MoveNext
    Wend
        
    oRs.Close
     
    vResponse.Add False, Key:="error"
    vResponse.Add vItems, Key:="items"
     
    oObjectContext.SetComplete
    Set GetBasketItems = vResponse

    Exit Function
    
GetBasketItemsErr:
    oObjectContext.SetAbort
    Set GetBasketItems = RaiseError("GetBasketItems")
End Function


Public Function EmptyBasket(ByVal vOrderID As Variant) As Variant
    On Error GoTo EmptyBasketErr
    
    Dim vResponse As New Collection
    Dim vSql As Variant
    
    Let vSql = "DELETE FROM BasketContents" & _
               " WHERE OrderID = " & vOrderID & ";"
    Set oDb = oObjectContext.CreateInstance("ADODB.Connection")
    oDb.Open vDbConn
    Call oDb.Execute(vSql)
     
    vResponse.Add False, Key:="error"
    
    oObjectContext.SetComplete
    Set EmptyBasket = vResponse

    Exit Function
    
EmptyBasketErr:
    oObjectContext.SetAbort
    Set EmptyBasket = RaiseError("EmptyBasket")
End Function

Public Function AddItem(ByVal vOrderID As Variant, ByVal vCatalogId As Variant, ByVal vNumItems As Variant) As Variant
    On Error GoTo AddItemErr

    Dim vResponse As New Collection
    Dim vSql As Variant
    
    Let vSql = "SELECT * FROM BasketContents " & _
        "WHERE (OrderID = " & vOrderID & ")" & _
        " AND (CatalogId = " & vCatalogId & ") ;"
    Set oRs = oObjectContext.CreateInstance("ADODB.Recordset")
    oRs.CursorType = adOpenDynamic
    oRs.LockType = adLockPessimistic
    oRs.Open vSql, vDbConn
    
    If oRs.EOF Then
        oRs.Close
        
        oRs.Open "BasketContents", vDbConn, adOpenKeyset, adLockPessimistic, adCmdTable
        oRs.AddNew
        oRs.Fields("OrderID") = vOrderID
        oRs.Fields("CatalogId") = CLng(vCatalogId)
        oRs.Fields("NumItems") = CLng(vNumItems)
    Else
        oRs.Fields("NumItems") = oRs.Fields("NumItems") + CLng(vNumItems)
    End If
        
    oRs.Update
    oRs.Close
    vResponse.Add False, Key:="error"
    
    oObjectContext.SetComplete
    Set AddItem = vResponse
    
    Exit Function
    
AddItemErr:
    oObjectContext.SetAbort
    Set AddItem = RaiseError("AddItem")

End Function

Public Function GetOrder(ByVal vEmail As Variant) As Variant
    On Error GoTo GetOrderErr

    Dim vResponse As New Collection
    Dim vSql As Variant
    Dim vOrderID As Variant
    
    Let vSql = "SELECT * FROM ORDERBASKET WHERE (Email = '" & Trim(vEmail) & "')" & _
        "AND (Fulfilled = 0);"
    Set oRs = oObjectContext.CreateInstance("ADODB.Recordset")
    Trace vSql
    oRs.CursorType = adOpenDynamic
    oRs.LockType = adLockPessimistic
    oRs.Open vSql, vDbConn
    If oRs.EOF Then
        Dim vNow As Variant
        vNow = Now
        oRs.AddNew
        oRs.Fields("Email") = vEmail
        oRs.Fields("BasketCreation") = vNow
        oRs.Update
        oRs.Close
        vSql = "SELECT * FROM ORDERBASKET WHERE (Email = '" & Trim(vEmail) & "')" & _
        " AND (Fulfilled = 0) and BasketCreation = #" & vNow & "#;"
        Trace vSql
        oRs.Open vSql, vDbConn
    End If
    vOrderID = oRs("OrderID")
    oRs.Close
        
    vResponse.Add vOrderID, "OrderID"
    vResponse.Add False, Key:="error"
    
    oObjectContext.SetComplete
    Set GetOrder = vResponse
    
    Exit Function
    
GetOrderErr:
    oObjectContext.SetAbort
    Set GetOrder = RaiseError("GetOrder")

End Function

Public Function UpdateNumItems(ByVal vBasketId As Variant, ByVal vNumItems As Variant) As Variant
    On Error GoTo UpdateNumItemsErr

    Dim vResponse As New Collection
    Dim bRet As Boolean
    Dim vSql As Variant
    
    Let vSql = "SELECT * FROM BasketContents " & _
               " WHERE BasketId = " & vBasketId & ";"
      
    Set oRs = oObjectContext.CreateInstance("ADODB.Recordset")
    oRs.CursorType = adOpenDynamic
    oRs.LockType = adLockPessimistic
    oRs.Open vSql, vDbConn
    
    If oRs.EOF Then
        bRet = False
    Else
        oRs.Fields("NumItems") = CLng(vNumItems)
        oRs.Update
        bRet = True
    End If
        
    oRs.Close
    
    vResponse.Add False, Key:="error"
    
    oObjectContext.SetComplete
    Set UpdateNumItems = vResponse
    
    Exit Function
    
UpdateNumItemsErr:
    oObjectContext.SetAbort
    Set UpdateNumItems = RaiseError("UpdateNumItems")

End Function

